// Imports
import * as Auth from "/services/auth/auth.js";
import * as results from "/services/election/calculate-election-generic.js";
import * as PartyModel from "/services/model/party-model.js";
import * as CandidateListModel from "/services/model/candidateList-model.js";
import * as AreaModel from "/services/model/area-model.js";
import * as ResultsZone from "/components/visualization/results-zone.js";
import * as ResultsGeneral from "/components/visualization/results-general.js";

export async function mount(where, round) {
  const resultComponent = new ResultComponent(round);
  await resultComponent.mount(where);
}

class ResultComponent {
  constructor(round) {
    this.round = round;
    this.PartyModel = PartyModel.getPartyModel();
    this.CandidateListModel = CandidateListModel.getCandidateListModel();
    this.AreaModel = AreaModel.getAreaModel();
  }

  async mount(where) {
    this.PartyModel.current_user = await Auth.GetUser();
    this.CandidateListModel.current_user = await Auth.GetUser();
    this.AreaModel.current_user = await Auth.GetUser();
    const mountpoint = where;
    document.getElementById(mountpoint).innerHTML = /* HTML */ `
      <div class="tabs is-boxed is-toggle is-fullwidth">
        <ul>
          <li id="general" class="is-active">
            <a>
              <span>Général</span>
            </a>
          </li>
          <li id="areas">
            <a>
              <span>Circonscriptions</span>
            </a>
          </li>
          <li id="sections">
            <a>
              <span>Villes</span>
            </a>
          </li>
        </ul>
      </div>
      <div class="control filter">
        <label class="radio">
          <input type="radio" name="filter" value="partial" checked />
          Partiel
        </label>
        <label class="radio">
          <input type="radio" name="filter" value="completed" />
          Complété
        </label>
        <label class="radio">
          <input type="radio" name="filter" value="validated" />
          Validé
        </label>
      </div>
      <div id="results-general" class="columns"></div>
      <div id="results-zone" class="columns" style="display: none;"></div>
    `;
    this.calculator = await results.mountCalculator(this.round);
    await this.calculateResults();
    this.resultsZone = await ResultsZone.mount("results-zone", this);
    this.resultsGeneral = await ResultsGeneral.mount("results-general", this);
    this.handleDom();
  }

  progressBarTemplate(candidateList, color, electedsNumber) {
    return /* HTML */ `<div class="progressBar">
      <div
        class="progressBarValue"
        style="background-color : ${color}; width : ${candidateList.Percentage}%"
      >
        ${candidateList.Name +
        " (" +
        (candidateList.VoiceNumber != null
          ? candidateList.VoiceNumber + " votes soit : "
          : "") +
        candidateList.Percentage +
        "%" +
        (electedsNumber != null ? ", " + electedsNumber + " élus" : "")})
      </div>
    </div>`;
  }

  handleDom() {
    let resultHandler = this;
    document
      .getElementById("general")
      .addEventListener("click", async function () {
        document.getElementById("results-zone").style.display = "none";
        document.getElementById("results-general").style.display = "flex";
        await resultHandler.calculateResults();
        document.getElementById("sections").setAttribute("class", "");
        document.getElementById("areas").setAttribute("class", "");
        document.getElementById("general").setAttribute("class", "is-active");
      });
    document
      .getElementById("areas")
      .addEventListener("click", async function () {
        document.getElementById("results-zone").style.display = "flex";
        document.getElementById("results-general").style.display = "none";
        resultHandler.zone = "areas";
        await resultHandler.calculateResults();
        resultHandler.resultsZone.displayResults();
        document.getElementById("sections").setAttribute("class", "");
        document.getElementById("general").setAttribute("class", "");
        document.getElementById("areas").setAttribute("class", "is-active");
      });
    document
      .getElementById("sections")
      .addEventListener("click", async function () {
        document.getElementById("results-zone").style.display = "flex";
        document.getElementById("results-general").style.display = "none";
        resultHandler.zone = "sections";
        await resultHandler.calculateResults();
        resultHandler.resultsZone.displayResults();
        document.getElementById("areas").setAttribute("class", "");
        document.getElementById("general").setAttribute("class", "");
        document.getElementById("sections").setAttribute("class", "is-active");
      });

    let radioButtons = document.getElementsByName("filter");
    for (var i = 0; i < radioButtons.length; i++) {
      radioButtons[i].addEventListener("click", async (e) => {
        await this.calculateResults();
        this.resultsZone.displayResults();
        this.resultsGeneral.displayRoundResults();
      });
    }

    window.intervalRefreshResults = setInterval(async () => {
      this.calculateResults();
      this.resultsZone.displayResults();
      this.resultsGeneral.displayRoundResults();
    }, 10000);
  }

  async calculateResults() {
    this.filter = document.querySelector('input[name="filter"]:checked').value;
    this.results = await this.calculator.calculateResults(this.filter);
  }

  displayRoundResults() {
    document.getElementById(
      "detailed-results"
    ).innerHTML = `<h5 class="title is-5">Résultats détaillés du tour</h5>`;
    for (let i in this.results.roundResults) {
      document.getElementById(
        "detailed-results"
      ).innerHTML += this.progressBarTemplate(
        this.results.roundResults[i],
        this.results.roundResults[i].Color
      );
    }
  }
}
