// Imports
import * as Auth from "/services/auth/auth.js";
import * as PartyModel from "/services/model/party-model.js";
import * as CandidateListModel from "/services/model/candidateList-model.js";
import * as AreaModel from "/services/model/area-model.js";
import * as Common from "/services/common/common.js";

export async function mount(parent) {
  const detailedsResultsComponent = new DetailedsResultsComponent(parent);
  return detailedsResultsComponent;
}

class DetailedsResultsComponent {
  constructor(parent) {
    this.parent = parent;
    this.PartyModel = PartyModel.getPartyModel();
    this.CandidateListModel = CandidateListModel.getCandidateListModel();

    let resultHandler = this;
    document.addEventListener(
      "input",
      function __listener(event) {
        if (event.target.id == "select-areas") {
          if (event.target.value != 0) {
            let area = resultHandler.parent.parent.results.areasResults.find(
              (areaFind) => areaFind.ID == event.target.value
            );

            if (resultHandler.parent.parent.zone === "areas") {
              resultHandler.displayZoneResults(area);
              resultHandler.parent.areaDisplayed = area;
            } else if (resultHandler.parent.parent.zone === "sections") {
              resultHandler.parent.refreshSections(area);
              resultHandler.displayZoneResults(area.Sections[0]);
              resultHandler.parent.areaDisplayed = area;
              resultHandler.parent.sectionDisplayed = area.Sections[0];
            }
          }
        } else if (event.target.id == "select-sections") {
          let area = resultHandler.parent.parent.results.areasResults.find(
            (areaFind) =>
              areaFind.ID == document.getElementById("select-areas").value
          );
          let section = area.Sections.find(
            (sectionFind) => sectionFind.ID == event.target.value
          );
          resultHandler.displayZoneResults(section);
          resultHandler.parent.sectionDisplayed = section;
        }
      },
      false
    );
  }

  displayAreasResults() {
    this.parent.refreshAreas();
    document.getElementById("select-sections").parentNode.style.display =
      "none";

    if (
      this.parent.parent.zone == "areas" &&
      this.parent.areaDisplayed != undefined
    ) {
      document.getElementById(
        "select-areas"
      ).value = this.parent.areaDisplayed.ID;
      this.displayZoneResults(this.parent.areaDisplayed);
    } else this.displayZoneResults(this.parent.parent.results.areasResults[0]);
  }

  displaySectionsResults() {
    this.parent.refreshAreas();
    document.getElementById("select-sections").parentNode.style.display =
      "block";
    this.parent.refreshSections(this.parent.parent.results.areasResults[0]);

    if (
      this.parent.parent.zone == "sections" &&
      this.parent.sectionDisplayed != undefined
    ) {
      document.getElementById(
        "select-areas"
      ).value = this.parent.areaDisplayed.ID;
      this.parent.refreshSections(this.parent.areaDisplayed);
      document.getElementById(
        "select-sections"
      ).value = this.parent.sectionDisplayed.ID;
      this.displayZoneResults(this.parent.sectionDisplayed);
    } else {
      this.displayZoneResults(
        this.parent.parent.results.areasResults[0].Sections[0]
      );
    }
  }

  async displayZoneResults(zone) {
    if (zone.status !== this.parent.parent.filter) {
      if (zone.status == "no_results") {
        document.getElementById(
          "zone-results"
        ).innerHTML = Common.warningMessage(
          "Pas de résultats",
          "Aucun résultats n'ont étaient saisis sur cette zone"
        );
      } else if (zone.status == "incompleted") {
        document.getElementById(
          "zone-results"
        ).innerHTML = Common.warningMessage(
          "Pas complets",
          "Les résultats pour cette zone ne sont pas complets"
        );
      } else if (zone.status == "not validated") {
        document.getElementById(
          "zone-results"
        ).innerHTML = Common.warningMessage(
          "Non validé",
          "Les résultats pour cette zone n'ont pas étaient validés"
        );
      }
      document.getElementById("zone-detaileds-results").innerHTML = "";
    } else {
      document.getElementById("zone-results").innerHTML =
        '<br/><h5 class="title is-5">Résultats</h5>';
      for (let i in zone.candidateLists) {
        let electedsNumber = null;
        if (
          this.parent.parent.zone === "areas" &&
          zone.candidateLists[i].SeatsAttributed > 0 &&
          zone.stats.PercentageConsiderated == 100
        ) {
          electedsNumber = zone.candidateLists[i].SeatsAttributed;
        }
        let party = await this.PartyModel.getParty(
          zone.candidateLists[i].PartyID
        );
        document.getElementById(
          "zone-results"
        ).innerHTML += this.parent.parent.progressBarTemplate(
          zone.candidateLists[i],
          party.Color,
          electedsNumber
        );
      }
      this.displayZoneDetailedResults(zone);
    }
    document.getElementById(
      "detailed-results"
    ).scrollTop = document.getElementById("zone-results").offsetTop;
  }

  async displayZoneDetailedResults(zone) {
    document.getElementById("zone-detaileds-results").innerHTML =
      '<br/><h5 class="title is-5">Statistiques</h5>';

    if (this.parent.parent.filter === "partial")
      document.getElementById(
        "zone-detaileds-results"
      ).innerHTML += this.parent.parent.progressBarTemplate(
        {
          Name: "Pourcentage de saisie",
          Percentage: zone.stats.PercentageConsiderated,
          VoiceNumber: null,
        },
        "grey",
        null
      );
    document.getElementById(
      "zone-detaileds-results"
    ).innerHTML += this.parent.parent.progressBarTemplate(
      {
        Name: "Abstention",
        Percentage: zone.stats.Abstention,
        VoiceNumber: null,
      },
      "grey",
      null
    );
    document.getElementById(
      "zone-detaileds-results"
    ).innerHTML += this.parent.parent.progressBarTemplate(
      {
        Name: "Votes blancs",
        Percentage: zone.stats.BlankPercentage,
        VoiceNumber: zone.stats.BlankVoiceNumber,
      },
      "grey",
      null
    );
    document.getElementById(
      "zone-detaileds-results"
    ).innerHTML += this.parent.parent.progressBarTemplate(
      {
        Name: "Votes nuls",
        Percentage: zone.stats.NullVotePercentage,
        VoiceNumber: zone.stats.NullVoteVoiceNumber,
      },
      "grey",
      null
    );
    if (
      this.parent.parent.zone === "areas" &&
      zone.stats.PercentageConsiderated == 100
    ) {
      document.getElementById("zone-detaileds-results").innerHTML +=
        '<br/><h5 class="title is-5">Élus</h5>';
      for (let i in zone.Electeds) {
        let candidateList = await this.CandidateListModel.getCandidateList(
          zone.Electeds[i].CandidateListID
        );
        document.getElementById("zone-detaileds-results").innerHTML +=
          zone.Electeds[i].FullName + " (" + candidateList.Name + ")<br/>";
      }
    }
  }
}
