// Imports
import * as Auth from "/services/auth/auth.js";
import * as PartyModel from "/services/model/party-model.js";
import * as CandidateListModel from "/services/model/candidateList-model.js";
import * as AreaModel from "/services/model/area-model.js";
import * as Scroller from "/services/common/scroller.js";
import * as ResultsFlow from "/components/visualization/results-flow.js";
import * as ResultsDetaileds from "/components/visualization/results-detaileds.js";

export async function mount(where, parent) {
  const resultZoneComponent = new ResultZoneComponent(parent);
  await resultZoneComponent.mount(where);
  return resultZoneComponent;
}

class ResultZoneComponent {
  constructor(parent) {
    this.parent = parent;
    this.PartyModel = PartyModel.getPartyModel();
    this.CandidateListModel = CandidateListModel.getCandidateListModel();
    this.AreaModel = AreaModel.getAreaModel();
  }

  async mount(where) {
    this.PartyModel.current_user = await Auth.GetUser();
    this.CandidateListModel.current_user = await Auth.GetUser();
    this.AreaModel.current_user = await Auth.GetUser();
    const mountpoint = where;
    document.getElementById(mountpoint).innerHTML = /* HTML */ `
      <div class="column is-half">
        <div id="map-section" class="card-no-hover">
          <header class="card-header">
            <p class="card-header-title">
              Carte
            </p>
            <button id="zoom-map" class="button is-success">
              <span class="icon is-small">
                <i class="fa fa-expand-arrows-alt"></i>
              </span>
            </button>
          </header>
          <div id="map-component" class="card-content">Cartes</div>
        </div>
      </div>
      <div class="column">
        <div id="news-flow-section" class="card-no-hover">
          <header class="card-header">
            <p class="card-header-title">
              Actualités
            </p>
            <label class="checkbox">
              <input id="auto-scroll" type="checkbox" checked />
              Défilement automatique &nbsp
            </label>
            <button id="zoom-news-flow" class="button is-success">
              <span class="icon is-small">
                <i class="fa fa-expand-arrows-alt"></i>
              </span>
            </button>
          </header>
          <div class="card-content">
            <div id="news-flow" class="content">
              Flux d'actualité
            </div>
          </div>
        </div>
        <div id="results-section" class="card-no-hover" ">
        <header class="card-header">
          <p class="card-header-title">
            Résultats
          </p>
          <button id="zoom-results" class="button is-success">
            <span class="icon is-small">
              <i class="fa fa-expand-arrows-alt"></i>
            </span>
          </button>
        </header>
        <div class="card-content">
          <div id="detailed-results" class="content">
            <div class="control select">
              <select id="select-areas" class="input"></select>
            </div>
            <div class="control select">
              <select id="select-sections" class="input"></select>
            </div>
            <div id="zone-results"></div>
            <div id="zone-detaileds-results" style="display:none"></div>
          </div>
        </div>
      </div>
    `;
    this.ResultsFlow = await ResultsFlow.mount(this);
    this.ResultsDetaileds = await ResultsDetaileds.mount(this);
    this.scroller = Scroller.scrollInit(
      "news-flow",
      document.getElementById("auto-scroll")
    );
    this.handleDom();
  }

  handleDom() {
    let resultHandler = this;
    document.getElementById("zoom-map").addEventListener("click", function () {
      resultHandler.zoomMap();
    });
    document
      .getElementById("zoom-news-flow")
      .addEventListener("click", function () {
        resultHandler.zoomNewsFlow();
      });
    document
      .getElementById("zoom-results")
      .addEventListener("click", function () {
        resultHandler.zoomResults();
      });

    let radioButtons = document.getElementsByName("filter");
    for (var i = 0; i < radioButtons.length; i++) {
      radioButtons[i].addEventListener("click", async (e) => {
        await this.parent.calculateResults();
        if (this.areaDisplayed !== undefined) {
          this.areaDisplayed = resultHandler.parent.results.areasResults.find(
            (areaFind) => areaFind.ID == this.areaDisplayed.ID
          );
          if (this.sectionDisplayed !== undefined)
            this.sectionDisplayed = this.areaDisplayed.Sections.find(
              (sectionFind) => sectionFind.ID == this.sectionDisplayed.ID
            );
        }
        await this.displayResults();
      });
    }
  }

  zoomMap() {
    let resultHandler = this;
    document.getElementById("map-section").parentElement.className =
      "column is-full";
    document.getElementById("zoom-map").addEventListener("click", function () {
      resultHandler.unZoom();
    });
    document.getElementById("zoom-map").innerHTML = /* HTML */ `<span
      class="icon is-small"
    >
      <i class="fa fa-compress-arrows-alt"></i>
    </span>`;
  }

  zoomNewsFlow() {
    let resultHandler = this;
    document.getElementById("news-flow-section").parentElement.className =
      "column is-full";
    document.getElementById("news-flow-section").style.height = "70vh";
    document.getElementById("map-section").parentElement.className = "column";
    document.getElementById("map-section").parentElement.style.display = "none";
    document.getElementById("results-section").style.display = "none";
    document
      .getElementById("zoom-news-flow")
      .addEventListener("click", function () {
        resultHandler.unZoom();
      });
    document.getElementById("zoom-news-flow").innerHTML = /* HTML */ `<span
      class="icon is-small"
    >
      <i class="fa fa-compress-arrows-alt"></i>
    </span>`;
  }

  zoomResults() {
    let resultHandler = this;
    document.getElementById("results-section").parentElement.className =
      "column is-full";
    document.getElementById("results-section").style.height = "70vh";
    document.getElementById("map-section").parentElement.className = "column";
    document.getElementById("map-section").parentElement.style.display = "none";
    document.getElementById("news-flow-section").style.display = "none";
    document
      .getElementById("zoom-results")
      .addEventListener("click", function () {
        resultHandler.unZoom();
      });
    document.getElementById("zoom-results").innerHTML = /* HTML */ `<span
      class="icon is-small"
    >
      <i class="fa fa-compress-arrows-alt"></i>
    </span>`;
    document.getElementById("zone-detaileds-results").style.display = "block";
  }

  unZoom() {
    document.getElementById("map-section").parentElement.className =
      "column is-half";
    document.getElementById("news-flow-section").style.height = "45vh";
    document.getElementById("results-section").style.height = "25vh";
    document.getElementById("news-flow-section").parentElement.className =
      "column is-half";
    document.getElementById("map-section").parentElement.style.display =
      "block";
    document.getElementById("results-section").style.display = "block";
    document.getElementById("news-flow-section").style.display = "block";
    document.getElementById("zone-detaileds-results").style.display = "none";
    document.getElementById("zoom-map").innerHTML = /* HTML */ `<span
      class="icon is-small"
    >
      <i class="fa fa-expand-arrows-alt"></i>
    </span>`;
    document.getElementById("zoom-news-flow").innerHTML = /* HTML */ `<span
      class="icon is-small"
    >
      <i class="fa fa-expand-arrows-alt"></i>
    </span>`;
    document.getElementById("zoom-results").innerHTML = /* HTML */ `<span
      class="icon is-small"
    >
      <i class="fa fa-expand-arrows-alt"></i>
    </span>`;

    this.handleDom();
  }

  async displayResults() {
    document.getElementById("news-flow").innerHTML = "";
    if (this.parent.zone === "areas") {
      await this.ResultsFlow.displayFlowAreas();
      this.ResultsDetaileds.displayAreasResults();
    } else if (this.parent.zone === "sections") {
      await this.ResultsFlow.displayFlowSections();
      this.ResultsDetaileds.displaySectionsResults();
    }
  }

  refreshSections(area) {
    let selectSections = document.getElementById("select-sections");
    selectSections.parentNode.style.display = "block";
    for (let i = selectSections.options.length - 1; i >= 0; i--) {
      selectSections.remove(i);
    }
    for (let i in area.Sections) {
      let el = document.createElement("option");
      el.textContent = area.Sections[i].Name;
      el.value = area.Sections[i].ID;
      selectSections.appendChild(el);
    }
  }

  refreshAreas() {
    let selectAreas = document.getElementById("select-areas");

    for (let i = selectAreas.options.length - 1; i >= 0; i--) {
      selectAreas.remove(i);
    }

    this.parent.results.areasResults.forEach((area) => {
      let el = document.createElement("option");
      el.textContent = area.Name;
      el.value = area.ID;
      selectAreas.appendChild(el);
    });
  }
}
