// Imports
import * as PartyModel from "/services/model/party-model.js";
import * as AreaModel from "/services/model/area-model.js";

export async function mount(parent) {
  const flowComponent = new FlowComponent(parent);
  return flowComponent;
}

class FlowComponent {
  constructor(parent) {
    this.parent = parent;
    this.PartyModel = PartyModel.getPartyModel();
    this.AreaModel = AreaModel.getAreaModel();
  }

  resultFlowTemplate(zone) {
    let resultHandler = this;
    let html = document.createElement("div");
    html.classList = "card-list card-no-hover";
    html.innerHTML = /* HTML */ `
      <div class="card-content clickable">
        <div id="flow-content-${zone.ID}" class="content">
          <h5 class="title is-5">${zone.Name}</h5>
        </div>
      </div>
    `;
    html.addEventListener("click", async () => {
      if (this.parent.parent.zone == "sections") {
        let area = await this.AreaModel.getArea(zone.AreaID);
        this.parent.refreshSections(area);
        document.getElementById("select-sections").value = zone.ID;
        document.getElementById("select-areas").value = zone.AreaID;
        resultHandler.areaDisplayed = area;
        resultHandler.sectionDisplayed = area.Sections[0];
      } else {
        document.getElementById("select-areas").value = zone.ID;
        resultHandler.areaDisplayed = area;
      }
      this.parent.displayZoneResults(zone);
    });
    return html;
  }

  async displayFlowAreas() {
    let areasResults = this.parent.parent.results.areasResults;
    areasResults.sort(function (a, b) {
      return b.DateCompletion - a.DateCompletion;
    });
    for (let j in areasResults) {
      let area = areasResults[j];
      if (area.status === this.parent.parent.filter) {
        document
          .getElementById("news-flow")
          .appendChild(this.resultFlowTemplate(area));

        for (let i in area.candidateLists) {
          let party = await this.PartyModel.getParty(
            area.candidateLists[i].PartyID
          );

          document.getElementById(
            "flow-content-" + area.ID
          ).innerHTML += await this.parent.parent.progressBarTemplate(
            area.candidateLists[i],
            party.Color
          );
        }
      }
    }
  }

  async displayFlowSections() {
    let sections = [];
    this.parent.parent.results.areasResults.forEach((area) => {
      sections = sections.concat(area.Sections);
    });
    sections.sort(function (a, b) {
      return b.DateCompletion - a.DateCompletion;
    });

    for (let j in sections) {
      let section = sections[j];
      if (section.status === this.parent.parent.filter) {
        document
          .getElementById("news-flow")
          .appendChild(this.resultFlowTemplate(section));

        for (let i in section.candidateLists) {
          let party = await this.PartyModel.getParty(
            section.candidateLists[i].PartyID
          );

          document.getElementById(
            "flow-content-" + section.ID
          ).innerHTML += await this.parent.parent.progressBarTemplate(
            section.candidateLists[i],
            party.Color
          );
        }
      }
    }
  }
}
