// Imports

export async function mount(where, round) {
  const resultComponent = new ResultComponent(round);
  await resultComponent.mount(where);
}

class ResultComponent {
  constructor(round) {
    this.round = round;
  }

  async mount(where) {
    const mountpoint = where;
    document.getElementById(mountpoint).innerHTML = /* HTML */ `
      <div class="tabs is-boxed is-toggle is-fullwidth">
        <ul>
          <li id="areas" class="is-active">
            <a>
              <span>Circonscriptions</span>
            </a>
          </li>
          <li id="sections">
            <a>
              <span>Villes</span>
            </a>
          </li>
        </ul>
      </div>
      <div class="control filter">
        <label class="radio">
          <input type="radio" name="answer" checked />
          Partiel
        </label>
        <label class="radio">
          <input type="radio" name="answer" />
          Complété
        </label>
        <label class="radio">
          <input type="radio" name="answer" />
          Validé
        </label>
      </div>
      <div class="columns">
        <div class="column is-half">
          <div id="map-section" class="card-no-hover">
            <header class="card-header">
              <p class="card-header-title">
                Carte
              </p>
              <button id="zoom-map" class="button is-success">
                <span class="icon is-small">
                  <i class="fas fa-search"></i>
                </span>
              </button>
            </header>
            <div class="card-content">
              <div id="round-list" class="content">
                La carte du tour
              </div>
            </div>
          </div>
        </div>
        <div class="column">
          <div id="news-flow-section" class="card-no-hover">
            <header class="card-header">
              <p class="card-header-title">
                Actualités
              </p>
              <button id="zoom-news-flow" class="button is-success">
                <span class="icon is-small">
                  <i class="fas fa-search"></i>
                </span>
              </button>
            </header>
            <div class="card-content">
              <div id="round-list" class="content">
                Flux d'actualité
              </div>
            </div>
          </div>
          <div id="results-section" class="card-no-hover" ">
          <header class="card-header">
            <p class="card-header-title">
              Résultats
            </p>
            <button id="zoom-results" class="button is-success">
              <span class="icon is-small">
                <i class="fas fa-search"></i>
              </span>
            </button>
          </header>
          <div class="card-content">
            <div id="round-list" class="content">
              Résultats détaillés du tour
            </div>
          </div>
        </div>
      </div>
    `;
    this.handleDom();
    document.getElementById("areas").click();
  }

  handleDom() {
    document.getElementById("areas").addEventListener("click", function () {
      document.getElementById("sections").setAttribute("class", "");
      document.getElementById("areas").setAttribute("class", "is-active");
    });
    document.getElementById("sections").addEventListener("click", function () {
      document.getElementById("areas").setAttribute("class", "");
      document.getElementById("sections").setAttribute("class", "is-active");
    });

    let resultHandler = this;
    document.getElementById("zoom-map").addEventListener("click", function () {
      resultHandler.zoomMap();
    });
    document
      .getElementById("zoom-news-flow")
      .addEventListener("click", function () {
        resultHandler.zoomNewsFlow();
      });
    document
      .getElementById("zoom-results")
      .addEventListener("click", function () {
        resultHandler.zoomResults();
      });
  }

  zoomMap() {
    let resultHandler = this;
    document.getElementById("map-section").parentElement.className =
      "column is-full";
    document.getElementById("zoom-map").addEventListener("click", function () {
      resultHandler.unZoom();
    });
  }

  zoomNewsFlow() {
    let resultHandler = this;
    document.getElementById("news-flow-section").parentElement.className =
      "column is-full";
    document.getElementById("news-flow-section").style.height = "auto";
    document.getElementById("map-section").parentElement.className = "column";
    document.getElementById("map-section").parentElement.style.display = "none";
    document.getElementById("results-section").style.display = "none";
    document
      .getElementById("zoom-news-flow")
      .addEventListener("click", function () {
        resultHandler.unZoom();
      });
  }

  zoomResults(){
    let resultHandler = this;
    document.getElementById("results-section").parentElement.className =
      "column is-full";
    document.getElementById("map-section").parentElement.className = "column";
    document.getElementById("map-section").parentElement.style.display = "none";
    document.getElementById("news-flow-section").style.display = "none";
    document
      .getElementById("zoom-results")
      .addEventListener("click", function () {
        resultHandler.unZoom();
      });
  }

  unZoom() {
    document.getElementById("map-section").parentElement.className =
      "column is-half";
    document.getElementById("news-flow-section").style.height = "45vh";
    document.getElementById("news-flow-section").parentElement.className =
      "column is-half";
    document.getElementById("map-section").parentElement.style.display =
      "block";
    document.getElementById("results-section").style.display = "block";
    document.getElementById("news-flow-section").style.display = "block";

    this.handleDom();
  }
}
