// Imports
import * as RoundSelection from "/components/visualization/round-selection.js";
import * as ResultSection from "/components/visualization/results-section.js";

export async function mount(where) {
  const visualizationPage = new VisualizationPage();
  await visualizationPage.mount(where);
}

class VisualizationPage {
  constructor() {}

  async mount(where) {
    const mountpoint = where;
    document.getElementById(mountpoint).innerHTML = /* HTML */ `
      <section
        id="visualization-section"
        style="margin-bottom: 230px;"
      ></section>
    `;
    this.handleDom();
    await RoundSelection.mount("visualization-section", this);
  }

  handleDom() {}
  async displayRound(round) {
    this.resultSection = await ResultSection.mount("visualization-section", round);
  }
}
