// Imports
import * as Auth from "/services/auth/auth.js";
import * as PartyModel from "/services/model/party-model.js";
import * as CandidateListModel from "/services/model/candidateList-model.js";
import * as AreaModel from "/services/model/area-model.js";
import * as Common from "/services/common/common.js";

export async function mount(where, parent) {
  const resultGeneralComponent = new ResultGeneralComponent(parent);
  await resultGeneralComponent.mount(where);
  return resultGeneralComponent;
}

class ResultGeneralComponent {
  constructor(parent) {
    this.parent = parent;
    this.PartyModel = PartyModel.getPartyModel();
    this.CandidateListModel = CandidateListModel.getCandidateListModel();
    this.AreaModel = AreaModel.getAreaModel();
  }

  async mount(where) {
    this.PartyModel.current_user = await Auth.GetUser();
    this.CandidateListModel.current_user = await Auth.GetUser();
    this.AreaModel.current_user = await Auth.GetUser();
    const mountpoint = where;
    document.getElementById(mountpoint).innerHTML = /* HTML */ `
      <div class="column is-half">
        <div class="card-no-hover">
          <header class="card-header">
            <p class="card-header-title">
              Résultats du tour
            </p>
          </header>
          <div id="round-results" class="content"></div>
          <div id="round-detaileds-results" class="content"></div>
        </div>
      </div>
      <div class="column is-half">
        <div class="card-no-hover">
          <header class="card-header">
            <p class="card-header-title">
              Statistiques
            </p>
          </header>
          <div id="stats-results" class="content"></div>
        </div>
      </div>
    `;
    this.handleDom();
    this.displayRoundResults();
  }

  handleDom() {}

  displayRoundResults() {
    document.getElementById("round-results").innerHTML = "";
    if (this.parent.results.status == this.parent.filter) {
      for (let i in this.parent.results.roundResults) {
        let electeds = this.parent.results.candidateLists
          .filter((candidateList) => {
            return (
              candidateList.PartyID == this.parent.results.roundResults[i].ID
            );
          })
          .reduce((electedsTotal, candidateList) => {
            return electedsTotal + candidateList.SeatsAttributed;
          }, 0);
        document.getElementById(
          "round-results"
        ).innerHTML += this.parent.progressBarTemplate(
          this.parent.results.roundResults[i],
          this.parent.results.roundResults[i].Color,
          electeds
        );
      }
      this.displayRoundDetailedResults();
    } else {
      if (this.parent.results.status == "no_results") {
        document.getElementById(
          "round-results"
        ).innerHTML = Common.warningMessage(
          "Pas de résultats",
          "Aucun résultats n'ont étaient saisis sur cette zone"
        );
      } else if (this.parent.results.status == "incompleted") {
        document.getElementById(
          "round-results"
        ).innerHTML = Common.warningMessage(
          "Pas complets",
          "Les résultats pour cette zone ne sont pas complets"
        );
      } else if (this.parent.results.status == "not validated") {
        document.getElementById(
          "round-results"
        ).innerHTML = Common.warningMessage(
          "Non validé",
          "Les résultats pour cette zone n'ont pas étaient validés"
        );
      }
      document.getElementById("round-detaileds-results").innerHTML = "";
    }
  }

  async displayRoundDetailedResults() {
    document.getElementById("round-detaileds-results").innerHTML =
      '<br/><h5 class="title is-5">Statistiques</h5>';

    if (this.parent.filter === "partial")
      document.getElementById(
        "round-detaileds-results"
      ).innerHTML += this.parent.progressBarTemplate(
        {
          Name: "Pourcentage de saisie",
          Percentage: this.parent.results.stats.PercentageConsiderated,
          VoiceNumber: null,
        },
        "grey",
        null
      );
    document.getElementById(
      "round-detaileds-results"
    ).innerHTML += this.parent.progressBarTemplate(
      {
        Name: "Abstention",
        Percentage: this.parent.results.stats.Abstention,
        VoiceNumber: null,
      },
      "grey",
      null
    );
    document.getElementById(
      "round-detaileds-results"
    ).innerHTML += this.parent.progressBarTemplate(
      {
        Name: "Votes blancs",
        Percentage: this.parent.results.stats.BlankPercentage,
        VoiceNumber: this.parent.results.stats.BlankVoiceNumber,
      },
      "grey",
      null
    );
    document.getElementById(
      "round-detaileds-results"
    ).innerHTML += this.parent.progressBarTemplate(
      {
        Name: "Votes nuls",
        Percentage: this.parent.results.stats.NullVotePercentage,
        VoiceNumber: this.parent.results.stats.NullVoteVoiceNumber,
      },
      "grey",
      null
    );
  }
}
