// Imports
import * as Auth from "/services/auth/auth.js";
import * as ElectionModel from "/services/model/election-model.js";
import * as RoundModel from "/services/model/round-model.js";

export async function mount(where, parent) {
  const roundSelectionComponent = new RoundSelectionComponent(parent);
  await roundSelectionComponent.mount(where);
}

class RoundSelectionComponent {
  constructor(parent) {
    this.parent = parent;
    this.ElectionModel = ElectionModel.getElectionModel();
    this.RoundModel = RoundModel.getRoundModel();
  }

  async mount(where) {
    this.ElectionModel.current_user = await Auth.GetUser();
    this.RoundModel.current_user = await Auth.GetUser();
    const mountpoint = where;
    document.getElementById(mountpoint).innerHTML = /* HTML */ `
      <div class="container">
        <div class="card-no-hover">
          <header class="card-header">
            <p class="card-header-title">
              Tours
            </p>
          </header>
          <div class="card-content">
            <div id="round-list" class="content">Liste des tours</div>
          </div>
        </div>
      </div>
    `;
    this.displayRounds();
  }

  roundTemplate(round) {
    return /* HTML */ `<div class="card card-list">
      <div id="rounds-round-${round.ID}" class="card-content clickable">
        <div class="content">
          <nav class="level">
            <div id="rounds-round-desc-${round.ID}" class="level-left">
              (tour : ${round.Round}, date :
              ${new Date(round.Date).toLocaleDateString()})
            </div>
          </nav>
        </div>
      </div>
    </div>`;
  }

  async displayRounds() {
    let rounds = await this.RoundModel.getRounds();
    const markup = rounds.map((round) => this.roundTemplate(round)).join("");
    document.getElementById("round-list").innerHTML = markup;

    let roundHandler = this;
    rounds.map(async (round) => {
      let election = await this.ElectionModel.getElection(round.ElectionID);
      document.getElementById(`rounds-round-desc-${round.ID}`).innerHTML =
        election.Name +
        " " +
        document.getElementById(`rounds-round-desc-${round.ID}`).innerHTML;
      document
        .getElementById(`rounds-round-${round.ID}`)
        .addEventListener("click", async function () {
          roundHandler.activateRound(round);
        });
    });
  }

  async activateRound(round) {
    await this.parent.displayRound(round);
  }
}
