#!/usr/bin/env python
# coding: utf-8

# In[1]:

import sys
import pandas as pd
import osmium


# In[2]:


#fichier_bal = './bal_extrait.csv'
fichier_bal = './bal_200046977.csv'
fichier_codes = './correspondance-code-insee-code-postal-gl.csv'
fichier_pbf =  sys.argv[1]


# premier indice osm_id dans les données résultat
# start_id = 100000000000
start_id = 1000


# In[3]:


df = pd.read_csv(fichier_bal,sep=';',header=0,index_col='cle_producteur',decimal='.',encoding='utf-8')

df = df.drop(['x', 'y'], axis=1)

# remplacement des valeurs nulles à '' dans 'numero'
df.loc[df['numero'].isnull(), 'numero'] = ''
df = df.astype({'numero': str})
# les entiers ont été transformés en flottant (.0) dans l'opération, suppression de la décimale
df['numero'] = df['numero'].str[:-2]
df['numero'] = df['numero'].replace('99999', '')

# remplacement des valeurs nulles à '' dans 'suffixe'
df.loc[df['suffixe'].isnull(), 'suffixe'] = ''
df = df.astype({'suffixe': str})

# extraction du code insee de la clé interop (utilisé pour la jointure avec les codes postaux)
df['insee'] = df['cle_interop'].str[:5]
df = df.astype({'insee': int})

df['addr:housenumber'] = df.numero.str.cat(df.suffixe,sep='')

df.rename(columns={'voie_nom': 'addr:street', 'commune_nom': 'addr:city', 'long': 'lon', 'date_der_maj': 'timestamp'}, inplace=True)

df.dtypes


# In[4]:


df


# In[5]:


df_codes = pd.read_csv(fichier_codes,sep=';',header=0,index_col=False,decimal='.',encoding='utf-8')
del df_codes['Commune']
df_codes.rename(columns={'Code INSEE': 'insee', 'Code Postal': 'addr:postcode'}, inplace=True)
df_codes = df_codes.astype({'addr:postcode': str})

df_codes.dtypes


# In[6]:


df = pd.merge(df, df_codes, on='insee')

df.head()


# In[7]:




writer = osmium.SimpleWriter(fichier_pbf)

i = 0


for index, row in df.iterrows():

    tags = {'addr:country':'FR', 'addr:city':row['addr:city'], 'addr:postcode':row['addr:postcode'], 'addr:street':row['addr:street']}

    if row['addr:housenumber'] != '':
        tags['addr:housenumber'] = row['addr:housenumber']

    tags['source'] = row['source']

    n = osmium.osm.mutable.Node(location=(row['lon'],row['lat']), id=(start_id+i), visible=True, tags=tags)
    n.user_is_anonymous = True

    writer.add_node(n)

    i += 1

writer.close()


# In[ ]:





# In[ ]:
