#!/bin/bash

### Nominatim ###

# Stop existing containers
docker-compose down
docker-compose rm -f
# Clear existing data
sudo rm -Rf ./nominatimdata && mkdir nominatimdata
sudo rm -Rf ./photondata && mkdir photondata

# Get the Métropole de Lyon database
# wget --directory-prefix=./bal2osm https://download.data.grandlyon.com/files/grandlyon/localisation/bal/bal_200046977.csv

# Generate OSM file
cd bal2osm
docker build -t bal2osm .


docker run -t \
-v `pwd`/../nominatimdata:/data \
bal2osm \
sh osmfile.sh /data/mdl-latest.osm.pbf
cd ..

# Build the image
cd nominatim-3.5
docker build -t nominatim .
cd ..


# Initialize the database
docker run -t \
-v `pwd`/nominatimdata:/data \
nominatim \
sh /app/init.sh /data/mdl-latest.osm.pbf postgresdata 4
