#!/bin/bash

#
# Install Atrium
#

mkdir -p /root/atrium/data && mkdir -p /root/atrium/letsencrypt_cache
sed -i "s/%atrium_hostname%/$(scw-userdata atrium_hostname)/g" /root/atrium.yaml
sed -i "s/%atrium_letsencrypt_email%/$(scw-userdata atrium_letsencrypt_email)/g" /root/atrium.yaml
sed -i "s/%atrium_count_index%/$(scw-userdata atrium_count_index)/g" /root/atrium.yaml
mv /root/atrium.yaml /root/atrium/atrium.yaml
chown -Rf 1000:1000 /root/atrium

#
# Run Atrium Container
#

docker run -d --name atrium \
       --restart unless-stopped \
       --net=host \
       -v /root/atrium/atrium.yaml:/app/atrium.yaml \
       -v /root/atrium/letsencrypt_cache:/app/letsencrypt_cache \
       -v /root/atrium/data:/app/data nicolaspernoud/atrium:latest
