#!/bin/bash

#
# Install Code Server
#

# cloud-init execute the bash script before HOME and USER are set.
export HOME=/root
export USER=root

mkdir -p  /root/.config/code-server/
sed -i "s/%user_password%/$(scw-userdata user_password)/g" /root/config.yaml
mv /root/config.yaml /root/.config/code-server/config.yaml
curl -fsSL https://code-server.dev/install.sh | sh

#
# Run Code Server
#

sudo systemctl enable --now code-server@$USER