import React, { useState } from 'react'
import axios from 'axios'
import { User } from '../models/user.model'

const _apiUrl: string = 'https://localhost:1443/'

export interface Auth {
  loginUser: () => Promise<void>
  error: null
  isUserLogged: () => Promise<boolean>
  getUser: () => User | undefined
  logoutUser: () => void
}
export const useAuth = (): Auth => {
  const [error, setError] = useState(null)

  //login user
  const loginUser = async (): Promise<void> => {
    try {
      await axios.get(`${_apiUrl}OAuth2Login`)
      const { data } = await axios.get(`${_apiUrl}api/common/WhoAmI`)
      if (data) {
        console.log('whomi', data)
        localStorage.setItem('user', JSON.stringify(data))
      }
    } catch (e) {
      setError(e)
    }
  }

  const logoutUser = (): void => {
    localStorage.removeItem('user')
  }

  const isUserLogged = async (): Promise<boolean> => {
    const user = localStorage.getItem('user')
    if (user) {
      try {
        const { data } = await axios.get(`${_apiUrl}api/common/WhoAmI`)
        if (data) {
          console.log(data)
          return true
        }
        return false
      } catch (e) {
        setError(e)
        return false
      }
    } else {
      return false
    }
  }
  const getUser = (): User | undefined => {
    const user = localStorage.getItem('user')
    if (user) return JSON.parse(user) as User
  }

  return { loginUser, error, isUserLogged, getUser, logoutUser }
}
