import axios from 'axios'
import { useQuery } from 'react-query'
import { toast } from 'react-toastify'
import { User } from './models/user.model'

const fetchWhoAmI = async () => {
  const { data } = await axios.get<User | null>('/api/common/WhoAmI')
  return data
}

export const useWhoAmI = () => {
  return useQuery({
    queryKey: ['WhoAmI'],
    queryFn: fetchWhoAmI,
    retry: false,
    onError: error => {
      console.error('error whoami', error)
      toast.error('Accès refusé, veuillez vous connecter')
    },
    refetchOnMount: false,
  })
}

export const fetchLogout = async () => {
  return await axios.get('/Logout')
}
