import { ThemeProvider } from '@mui/material'
import { QueryClient, QueryClientProvider } from 'react-query'
import { BrowserRouter } from 'react-router-dom'
import { ToastContainer } from 'react-toastify'
import 'react-toastify/dist/ReactToastify.css'
import Router from './components/Routes/Router'
import { theme } from './components/UI/theme'

const queryClient = new QueryClient()

function App() {
  return (
    <BrowserRouter>
      <ThemeProvider theme={theme}>
        <QueryClientProvider client={queryClient}>
          <Router />
          <ToastContainer theme="colored" />
        </QueryClientProvider>
      </ThemeProvider>
    </BrowserRouter>
  )
}
export default App
