import { Button, Dialog } from '@mui/material'
import React from 'react'
import downloadIcon from '../../assets/icons/ico-download.svg'
import styles from './DownloadModal.module.scss'

interface DownloadModalProps {
  open: boolean
  toggleOpenModal: () => void
  exportData: () => void
}
const DownloadModal: React.FC<DownloadModalProps> = ({
  open,
  toggleOpenModal,
  exportData,
}) => {
  return (
    <Dialog open={open} onClose={toggleOpenModal}>
      <div className={styles.modalContent}>
        <img
          src={downloadIcon}
          className={styles.modalIcon}
          alt="download-icon"
        />
        <div className={styles.modalTitle}>
          Voulez-vous télécharger les consentements sélectionnés ?
        </div>
        <div className={styles.text1}>
          Un fichier Excel contenant les consentements sera téléchargé.
        </div>
        <div className={styles.text2}>
          Attention ce fichier contient des données personnelles. Veillez à ne
          l&apos;utiliser qu&apos;en cas de contrôle de la part d&apos;Enedis et
          à supprimer ce fichier ensuite de tout ordinateur.
        </div>
        <div className="buttons">
          <Button variant="outlined" onClick={toggleOpenModal}>
            Annuler
          </Button>
          <Button onClick={exportData}>Télécharger</Button>
        </div>
      </div>
    </Dialog>
  )
}
export default DownloadModal
