import { Button, Dialog, IconButton } from '@mui/material'
import React, { useState } from 'react'
import leftChevron from '../../../assets/icons/left-chevron.svg'
import rightChevron from '../../../assets/icons/right-chevron.svg'
import './dateSelector.scss'

interface DateSelectorProps {
  date: Date
  setDate: React.Dispatch<React.SetStateAction<Date>>
  isEmpty: () => boolean
}

const DateSelector: React.FC<DateSelectorProps> = ({
  date,
  setDate,
  isEmpty,
}) => {
  const [openModal, setOpenModal] = useState<boolean>(false)
  const [isPrev, setIsPrev] = useState<boolean>(false)
  const toggleOpenModal = () => setOpenModal(prev => !prev)

  const handleNextMonth = () => {
    setIsPrev(false)
    if (isEmpty() || openModal) {
      const incremented: Date = new Date(date.setMonth(date.getMonth() + 1))
      setDate(incremented)
    } else {
      toggleOpenModal()
    }
  }

  const handlePrevMonth = () => {
    setIsPrev(true)
    if (isEmpty() || openModal) {
      const decremented: Date = new Date(date.setMonth(date.getMonth() - 1))
      setDate(decremented)
    } else {
      toggleOpenModal()
    }
  }
  const handleConfirmAlert = () => {
    isPrev ? handlePrevMonth() : handleNextMonth()
    setOpenModal(false)
  }
  return (
    <div className="date-selector">
      <IconButton onClick={handlePrevMonth}>
        <img src={leftChevron} alt="Previous Month" className="arrow" />
      </IconButton>
      <div className="text">
        {date.toLocaleString('default', { month: 'long', year: 'numeric' })}
      </div>
      <IconButton onClick={handleNextMonth}>
        <img src={rightChevron} alt="Next Month" className="arrow" />
      </IconButton>

      <Dialog open={openModal}>
        <div className="modal-text">
          Attention, vous n&apos;avez pas enregistré vos modifications.
          Celles-ci seront annulées en changeant de mois. Voulez-vous continuer
          ?
        </div>
        <div className="buttons">
          <Button variant="outlined" onClick={() => setOpenModal(false)}>
            Annuler
          </Button>
          <Button onClick={handleConfirmAlert}>Continuer</Button>
        </div>
      </Dialog>
    </div>
  )
}

export default DateSelector
