import React from 'react'
import './imagePicker.scss'
interface SingleImageProps {
  imageURL: string
  selectedImage: string
  setSelectedImageURL: React.Dispatch<React.SetStateAction<string>>
}

const SingleImage: React.FC<SingleImageProps> = ({
  imageURL,
  selectedImage,
  setSelectedImageURL,
}) => {
  const selectImage = (targetImage: string) => {
    setSelectedImageURL(targetImage)
  }
  return (
    <img
      src={imageURL}
      width="120"
      height="120"
      className={
        selectedImage === imageURL
          ? 'ecogesture-image selected'
          : 'ecogesture-image'
      }
      alt={'ecogesture' + imageURL.replace(/^\D+/g, '')}
      onClick={() => selectImage(imageURL)}
    />
  )
}

export default SingleImage
