import { Button, TextField } from '@mui/material'
import React, { ChangeEvent } from 'react'
import { EditorType } from '../CustomEditor'
import { ContentItems } from '../Newsletter'

interface MailSubjectProps {
  onSave: () => Promise<void>
  onCancel: () => void
  subject: string
  handleChange: (value: string, type: EditorType) => void
  onDelete: (target: ContentItems) => void
}
const MailSubject: React.FC<MailSubjectProps> = ({
  onSave,
  onCancel,
  subject,
  handleChange,
  onDelete,
}) => {
  const handleChangeSubject = (e: ChangeEvent<HTMLInputElement>) => {
    handleChange(e.target.value, 'subject')
  }
  return (
    <div className="mailSubject">
      <h2>Objet de la newsletter (Optionnel)</h2>
      <h3>Objet</h3>
      <TextField
        type="text"
        placeholder="Par défaut : [Ecolyo] Votre bilan..."
        value={subject}
        onChange={handleChangeSubject}
      />
      <div>
        <div className="buttons">
          <Button variant="outlined" onClick={onCancel}>
            Annuler
          </Button>
          <Button onClick={onSave}>Sauvegarder</Button>
          <Button
            style={{ marginLeft: 'auto' }}
            variant="text"
            onClick={() => onDelete('subject')}
          >
            Supprimer
          </Button>
        </div>
      </div>
    </div>
  )
}

export default MailSubject
