import { Button } from '@mui/material'
import React from 'react'
import 'react-draft-wysiwyg/dist/react-draft-wysiwyg.css'
import { convertStringToEditorState } from '../../../utils/editorStateManagement'
import CustomEditor, { EditorType } from '../CustomEditor'
import ImagePicker from '../ImagePicker/ImagePicker'
import { ContentItems } from '../Newsletter'

interface MonthlyInfoProps {
  handleChange: (value: string, type: EditorType) => void
  imageURL: string
  info: string
  onCancel: () => void
  onDelete: (target: ContentItems) => void
  onSave: () => Promise<void>
}
const MonthlyInfo: React.FC<MonthlyInfoProps> = ({
  handleChange,
  imageURL,
  info,
  onCancel,
  onDelete,
  onSave,
}) => {
  return (
    <div className="monthlyInfo">
      <h2>Informations du mois (Optionnel)</h2>
      <div>
        <h3>Image</h3>
        <ImagePicker imageURL={imageURL} handleChange={handleChange} />
        <h3>Info</h3>
        <CustomEditor
          baseState={convertStringToEditorState(info)}
          handleChange={handleChange}
          type="info"
        />
        <div className="buttons">
          <Button variant="outlined" onClick={onCancel}>
            Annuler
          </Button>
          <Button onClick={onSave}>Sauvegarder</Button>
          <Button
            style={{ marginLeft: 'auto' }}
            variant="text"
            onClick={() => onDelete('monthlyInfo')}
          >
            Supprimer
          </Button>
        </div>
      </div>
    </div>
  )
}

export default MonthlyInfo
