import { Button, TextField } from '@mui/material'
import React, { ChangeEvent } from 'react'
import 'react-draft-wysiwyg/dist/react-draft-wysiwyg.css'
import { convertStringToEditorState } from '../../../utils/editorStateManagement'
import CustomEditor, { EditorType } from '../CustomEditor'
import { ContentItems } from '../Newsletter'

interface MonthlyNewsProps {
  onSave: () => Promise<void>
  onCancel: () => void
  title: string
  content: string
  handleChange: (value: string, type: EditorType) => void
  onDelete: (target: ContentItems) => void
}
const MonthlyNews: React.FC<MonthlyNewsProps> = ({
  onSave,
  onCancel,
  title,
  content,
  handleChange,
  onDelete,
}) => {
  const handleChangeTitle = (e: ChangeEvent<HTMLInputElement>) => {
    handleChange(e.target.value, 'title')
  }
  return (
    <div className="monthlyNews">
      <h2>Nouveautés du mois (Optionnel)</h2>
      <h3>Titre</h3>
      <TextField
        type="text"
        placeholder="Par défaut : Les nouveautés du service"
        value={title}
        onChange={handleChangeTitle}
      />
      <div>
        <h3>Contenu</h3>
        <div>
          <CustomEditor
            baseState={convertStringToEditorState(content)}
            handleChange={handleChange}
            type="content"
          />
        </div>

        <div className="buttons">
          <Button variant="outlined" onClick={onCancel}>
            Annuler
          </Button>
          <Button onClick={onSave}>Sauvegarder</Button>
          <Button
            style={{ marginLeft: 'auto' }}
            variant="text"
            onClick={() => onDelete('monthlyNews')}
          >
            Supprimer
          </Button>
        </div>
      </div>
    </div>
  )
}

export default MonthlyNews
