import { Button, TextField } from '@mui/material'
import React, { ChangeEvent } from 'react'
import 'react-draft-wysiwyg/dist/react-draft-wysiwyg.css'
import { convertStringToEditorState } from '../../../utils/editorStateManagement'
import CustomEditor, { EditorType } from '../CustomEditor'
import { ContentItems } from '../Newsletter'

interface PollProps {
  question: string
  link: string
  handleChange: (value: string, type: EditorType) => void
  onSave: () => Promise<void>
  onCancel: () => void
  onDelete: (target: ContentItems) => void
}

const Poll: React.FC<PollProps> = ({
  question,
  link,
  handleChange,
  onSave,
  onCancel,
  onDelete,
}) => {
  const handleChangeLink = (e: ChangeEvent<HTMLInputElement>) => {
    handleChange(e.target.value, 'link')
  }

  return (
    <div className="poll">
      <h2>Ajouter un sondage (Optionnel)</h2>
      <h3>Lien</h3>
      <TextField type="text" value={link} onChange={handleChangeLink} />
      <div>
        <h3>Question</h3>
        <div>
          <CustomEditor
            baseState={convertStringToEditorState(question)}
            handleChange={handleChange}
            type="question"
          />
        </div>

        <div className="buttons">
          <Button variant="outlined" onClick={onCancel}>
            Annuler
          </Button>
          <Button onClick={onSave}>Sauvegarder</Button>
          <Button
            style={{ marginLeft: 'auto' }}
            variant="text"
            onClick={() => onDelete('poll')}
          >
            Supprimer
          </Button>
        </div>
      </div>
    </div>
  )
}

export default Poll
