import { Navigate, Route, Routes } from 'react-router-dom'
import { useWhoAmI } from '../../API'
import { Consents } from '../Consents/Consents'
import Loader from '../Loader/Loader'
import Login from '../Login/Login'
import Newsletter from '../Newsletter/Newsletter'
import Popups from '../Popups/Popups'
import Prices from '../Prices/Prices'
import SideBar from '../SideBar/SideBar'

export const links: Record<
  string,
  { label: string; path: string; adminOnly?: boolean }
> = {
  newsletter: {
    label: 'Newsletter',
    path: '/newsletter',
  },
  popups: {
    label: 'Pop-ups',
    path: '/popups',
  },
  prices: {
    label: 'Prix',
    path: '/prices',
  },
  sgeConsents: {
    label: 'Consentements SGE',
    path: '/consents/sge',
    adminOnly: true,
  },
  grdfConsents: {
    label: 'Consentements GRDF',
    path: '/consents/grdf',
    adminOnly: true,
  },
}

export const routes = Object.keys(links).map(key => ({
  label: links[key].label,
  path: links[key].path,
  adminOnly: links[key].adminOnly,
}))

const Router = () => {
  const { data: user, isLoading } = useWhoAmI()

  if (isLoading) return <Loader />

  if (user) {
    return (
      <>
        <SideBar />
        <main className="wrapper">
          <Routes>
            <Route path={links.newsletter.path} element={<Newsletter />} />
            <Route path={links.prices.path} element={<Prices />} />
            <Route path="/popups" element={<Popups />} />
            {user.isAdmin && (
              <>
                <Route
                  path={links.sgeConsents.path}
                  element={<Consents type="sge" />}
                />
                <Route
                  path={links.grdfConsents.path}
                  element={<Consents type="grdf" />}
                />
              </>
            )}
            <Route path="/login" element={<Login />} />
            <Route
              path="*"
              element={<Navigate replace to={links.newsletter.path} />}
            />
          </Routes>
        </main>
      </>
    )
  }

  return <Login />
}

export default Router
