import { Button } from '@mui/material'
import React from 'react'
import { useMutation } from 'react-query'
import { NavLink } from 'react-router-dom'
import { fetchLogout, useWhoAmI } from '../../API'
import logo from '../../assets/icons/ecolyo-logo.svg'
import { routes } from '../Routes/Router'
import './sidebar.scss'

const SideBar: React.FC = () => {
  const { data: user } = useWhoAmI()

  const { mutate: logout } = useMutation({
    mutationFn: fetchLogout,
    onMutate: () => {
      location.reload()
    },
  })

  if (!user) return <div />

  return (
    <nav className="menu">
      <div className="logo-container">
        <img src={logo} alt="Ecolyo logo" className="logo" />
      </div>
      <div className="menu-list">
        {user &&
          routes.map(
            route =>
              (!route.adminOnly || user.isAdmin) && (
                <NavLink
                  key={route.label}
                  to={route.path}
                  className={({ isActive }) => (isActive ? 'active' : '')}
                >
                  {route.label}
                </NavLink>
              )
          )}
        {process.env.NODE_ENV === 'development' && (
          <a href="/doc/" target="_blank">
            Swagger doc
          </a>
        )}
      </div>
      <div className="bottom">
        {user ? (
          <Button variant="outlined" onClick={() => logout()}>
            Logout
          </Button>
        ) : (
          <NavLink to="/login" className="active">
            Login
          </NavLink>
        )}
      </div>
    </nav>
  )
}

export default SideBar
