import { ColDef } from 'ag-grid-community'
import { DateTime } from 'luxon'
import { dateFormatter } from '../utils/dateFormatter'

export interface IGrdfConsent
  extends Omit<GrdfConsentEntity, 'CreatedAt' | 'endDate'> {
  startDate: DateTime
  endDate: DateTime
}

export interface GrdfConsentEntity {
  ID: number
  CreatedAt: string
  endDate: string
  firstname: string
  lastname: string
  pce: number
  postalCode: string
}

export interface IGrdfConsentPagination
  extends Omit<GrdfConsentPaginationEntity, 'rows'> {
  rows: IGrdfConsent[]
}

export interface GrdfConsentPaginationEntity {
  totalRows: number
  totalPages: number
  rows: GrdfConsentEntity[]
}

export const grdfColumnDef: ColDef[] = [
  {
    field: 'ID',
    hide: true,
  },
  {
    field: 'pce',
    headerName: 'N° PCE',
    initialWidth: 180,
    filter: true,
    checkboxSelection: true,
  },
  {
    field: 'lastname',
    headerName: 'Nom',
    initialWidth: 180,
    filter: true,
    cellStyle: { textTransform: 'uppercase' },
  },
  {
    field: 'firstname',
    headerName: 'Prénom',
    initialWidth: 180,
    filter: true,
    cellStyle: { textTransform: 'capitalize' },
  },
  {
    field: 'postalCode',
    headerName: 'CP',
    initialWidth: 80,
    filter: true,
  },
  {
    field: 'startDate',
    valueFormatter: dateFormatter,
    headerName: 'Début du consentement',
    initialWidth: 150,
    filter: true,
    sortable: false,
  },
  {
    field: 'endDate',
    valueFormatter: dateFormatter,
    headerName: 'Fin du consentement',
    initialWidth: 150,
    filter: true,
    sortable: false,
  },
]
