import { ColDef } from 'ag-grid-community'
import { DateTime } from 'luxon'
import { dateFormatter } from '../utils/dateFormatter'

export interface ISgeConsent
  extends Omit<SgeConsentEntity, 'CreatedAt' | 'endDate' | 'inseeCode'> {
  startDate: DateTime
  endDate: DateTime
}

export interface SgeConsentEntity {
  ID: number
  CreatedAt: string
  endDate: string
  firstname: string
  lastname: string
  pointID: number
  address: string
  postalCode: string
  inseeCode: string
  city: string
  safetyOnBoarding: boolean
}

export interface ISgeConsentPagination
  extends Omit<SgeConsentPaginationEntity, 'rows'> {
  rows: ISgeConsent[]
}

export interface SgeConsentPaginationEntity {
  totalRows: number
  totalPages: number
  rows: SgeConsentEntity[]
}

export const sgeColumnDefs: ColDef[] = [
  {
    field: 'ID',
    hide: true,
  },
  {
    field: 'pointID',
    headerName: 'N° PDL',
    initialWidth: 180,
    filter: true,
    checkboxSelection: true,
  },
  {
    field: 'lastname',
    headerName: 'Nom',
    initialWidth: 180,
    filter: true,
    cellStyle: { textTransform: 'uppercase' },
  },
  {
    field: 'firstname',
    headerName: 'Prénom',
    initialWidth: 180,
    filter: true,
    cellStyle: { textTransform: 'capitalize' },
  },
  {
    field: 'address',
    headerName: 'Adresse',
    initialWidth: 300,
    filter: true,
    flex: 1,
  },
  {
    field: 'postalCode',
    headerName: 'CP',
    initialWidth: 80,
    filter: true,
  },
  {
    field: 'city',
    headerName: 'Ville',
  },
  {
    field: 'safetyOnBoarding',
    headerName: 'Secours',
    initialWidth: 100,
  },
  {
    field: 'startDate',
    valueFormatter: dateFormatter,
    headerName: 'Début du consentement',
    initialWidth: 150,
    filter: true,
    sortable: false,
  },
  {
    field: 'endDate',
    valueFormatter: dateFormatter,
    headerName: 'Fin du consentement',
    initialWidth: 150,
    filter: true,
    sortable: false,
  },
]
