import axios, { AxiosRequestConfig } from 'axios'
import { toast } from 'react-toastify'
import { IPartnersInfo } from '../models/partnersInfo.model'
export class PartnersInfoService {
  /**
   * Save the partnersInfo
   * @param partnersInfo
   * @param axiosHeaders
   */
  public savePartnersInfo = async (
    partnersInfo: IPartnersInfo,
    axiosHeaders: AxiosRequestConfig
  ): Promise<void> => {
    try {
      await axios.put(
        `/api/animator/partnersInfo`,
        {
          grdf_failure: partnersInfo.grdf_failure,
          enedis_failure: partnersInfo.enedis_failure,
          egl_failure: partnersInfo.egl_failure,
          notification_activated: partnersInfo.notification_activated,
        },
        axiosHeaders
      )
      toast.success('Information des partenaires mises à jour !')
    } catch (e) {
      toast.error(
        'Erreur lors de la mise à jour des information des partenaires'
      )
      console.error(e)
    }
  }

  /**
   * Gets the partners information
   */
  public getPartnersInfo = async (): Promise<IPartnersInfo | null> => {
    try {
      const { data } = await axios.get(`/api/common/partnersInfo`)
      return data as IPartnersInfo
    } catch (e) {
      console.error('error', e)
      return null
    }
  }
}
