import { EditorState, ContentState } from 'draft-js'
import htmlToDraft from 'html-to-draftjs'

export const convertStringToEditorState = (string: string): EditorState => {
  const { contentBlocks, entityMap } = htmlToDraft(string)
  const state = ContentState.createFromBlockArray(contentBlocks, entityMap)
  return EditorState.createWithContent(state)
}
