import { useMutation, useQuery, useQueryClient } from '@tanstack/react-query'
import { AxiosRequestConfig } from 'axios'
import { fetchPartnersIssue, savePartnersInfo } from '../API'
import { IPartnersInfo } from '../models/partnersInfo.model'
import { queryKeys } from './query-keys'

export const usePartnersIssue = () => {
  const queryClient = useQueryClient()

  const partnersIssue = useQuery({
    queryKey: [queryKeys.partnersInfo],
    queryFn: fetchPartnersIssue,
  })

  const mutation = useMutation<
    void,
    unknown,
    { customPopup: IPartnersInfo; axiosHeaders: AxiosRequestConfig }
  >({
    mutationFn: ({ customPopup, axiosHeaders }) =>
      savePartnersInfo(customPopup, axiosHeaders),
    onSuccess: () => {
      queryClient.invalidateQueries({ queryKey: [queryKeys.partnersInfo] })
    },
  })

  const savePartnersIssue = (
    customPopup: IPartnersInfo,
    axiosHeaders: AxiosRequestConfig
  ) => {
    mutation.mutate({ customPopup, axiosHeaders })
  }

  return { partnersIssue, savePartnersIssue }
}
