import axios from 'axios'
import { useEffect, useState } from 'react'
import { toast } from 'react-toastify'
import { User } from '../models/user.model'

const useFindUser = () => {
  const [user, setUser] = useState<User | null>(null)
  const [isLoading, setLoading] = useState<boolean>(true)

  useEffect(() => {
    async function findUser() {
      try {
        const { data } = await axios.get(`/api/common/WhoAmI`)
        if (data) {
          setUser(data)
          setLoading(false)
        }
      } catch (error) {
        toast.error('Accès refusé, veuillez vous connecter')
      }
    }
    findUser()
  }, [])
  return {
    user,
    setUser,
    isLoading,
  }
}

export default useFindUser
