import { BrowserRouter } from 'react-router-dom'
import { ToastContainer } from 'react-toastify'
import 'react-toastify/dist/ReactToastify.css'
import Layout from './components/Layout/Layout'
import Router from './components/Routes/Router'
import useFindUser from './hooks/useFindUser'
import { UserContext } from './hooks/userContext'

function App() {
  const { user, setUser, isLoading } = useFindUser()

  return (
    <BrowserRouter>
      <UserContext.Provider value={{ user, setUser, isLoading }}>
        <Layout>
          <Router />
        </Layout>
      </UserContext.Provider>
      <ToastContainer theme="colored" />
    </BrowserRouter>
  )
}
export default App
