import React, { ChangeEvent } from 'react'
import { EditorType } from '../CustomEditor'
import { ContentItems } from '../Newsletter'
import './mailSubject.scss'

interface MailSubjectProps {
  onSave: () => Promise<void>
  onCancel: () => void
  subject: string
  handleChange: (value: string, type: EditorType) => void
  onDelete: (target: ContentItems) => void
}
const MailSubject: React.FC<MailSubjectProps> = ({
  onSave,
  onCancel,
  subject,
  handleChange,
  onDelete,
}) => {
  const handleChangeSubject = (e: ChangeEvent<HTMLInputElement>) => {
    handleChange(e.target.value, 'subject')
  }
  return (
    <div className="mailSubject">
      <h2>Objet de la newsletter (Optionnel)</h2>
      <p className="title">Objet</p>
      <input
        type="text"
        className="input-dark"
        placeholder="Par défaut : [Ecolyo] Votre bilan..."
        value={subject}
        onChange={handleChangeSubject}
      />
      <div>
        <div className="buttons">
          <button className="btnCancel" onClick={onCancel}>
            Annuler
          </button>
          <button className="btnValid" onClick={onSave}>
            Sauvegarder
          </button>
          <button className="btnDelete" onClick={() => onDelete('subject')}>
            Supprimer
          </button>
        </div>
      </div>
    </div>
  )
}

export default MailSubject
