import React, { ReactChild } from 'react'
import { createPortal } from 'react-dom'
import './modal.scss'
interface ModalProps {
  children: ReactChild
  classes?: string
}

const Modal: React.FC<ModalProps> = ({ children, classes }) => {
  return createPortal(
    <div className="modal-bg">
      <div className="modal-container">
        <div className={`modal-content ${classes}`}>{children}</div>
      </div>
    </div>,
    document.body
  )
}

export default Modal
