import React from 'react'
import 'react-draft-wysiwyg/dist/react-draft-wysiwyg.css'
import { convertStringToEditorState } from '../../../utils/editorStateManagement'
import CustomEditor, { EditorType } from '../CustomEditor'
import ImagePicker from '../ImagePicker/ImagePicker'
import { ContentItems } from '../Newsletter'
import './monthlyInfo.scss'

interface MonthlyInfoProps {
  onSave: () => Promise<void>
  onCancel: () => void
  info: string
  handleChange: (value: string, type: EditorType) => void
  onDelete: (target: ContentItems) => void
  imageURL: string
}
const MonthlyInfo: React.FC<MonthlyInfoProps> = ({
  onSave,
  onCancel,
  info,
  handleChange,
  onDelete,
  imageURL,
}) => {
  return (
    <div className="monthlyInfo">
      <h2>Informations du mois (Optionnel)</h2>
      <div>
        <p className="title">Image</p>
        <ImagePicker imageURL={imageURL} handleChange={handleChange} />
        <p className="title">Info</p>
        <CustomEditor
          baseState={convertStringToEditorState(info)}
          handleChange={handleChange}
          type="info"
        />
        <div className="buttons">
          <button className="btnCancel" onClick={onCancel}>
            Annuler
          </button>
          <button className="btnValid" onClick={onSave}>
            Sauvegarder
          </button>
          <button className="btnDelete" onClick={() => onDelete('monthlyInfo')}>
            Supprimer
          </button>
        </div>
      </div>
    </div>
  )
}

export default MonthlyInfo
