import React, { ChangeEvent } from 'react'
import 'react-draft-wysiwyg/dist/react-draft-wysiwyg.css'
import { convertStringToEditorState } from '../../../utils/editorStateManagement'
import CustomEditor, { EditorType } from '../CustomEditor'
import { ContentItems } from '../Newsletter'
import './monthlyNews.scss'

interface MonthlyNewsProps {
  onSave: () => Promise<void>
  onCancel: () => void
  title: string
  content: string
  handleChange: (value: string, type: EditorType) => void
  onDelete: (target: ContentItems) => void
}
const MonthlyNews: React.FC<MonthlyNewsProps> = ({
  onSave,
  onCancel,
  title,
  content,
  handleChange,
  onDelete,
}) => {
  const handleChangeTitle = (e: ChangeEvent<HTMLInputElement>) => {
    handleChange(e.target.value, 'title')
  }
  return (
    <div className="monthlyNews">
      <h2>Nouveautés du mois (Optionnel)</h2>
      <p className="title">Titre</p>
      <input
        type="text"
        className="input-dark"
        placeholder="Par défaut : Les nouveautés du service"
        value={title}
        onChange={handleChangeTitle}
      />
      <div>
        <p className="title">Contenu</p>
        <div>
          <CustomEditor
            baseState={convertStringToEditorState(content)}
            handleChange={handleChange}
            type="content"
          />
        </div>

        <div className="buttons">
          <button className="btnCancel" onClick={onCancel}>
            Annuler
          </button>
          <button className="btnValid" onClick={onSave}>
            Sauvegarder
          </button>
          <button className="btnDelete" onClick={() => onDelete('monthlyNews')}>
            Supprimer
          </button>
        </div>
      </div>
    </div>
  )
}

export default MonthlyNews
