import React, { ChangeEvent } from 'react'
import 'react-draft-wysiwyg/dist/react-draft-wysiwyg.css'
import { convertStringToEditorState } from '../../../utils/editorStateManagement'
import CustomEditor, { EditorType } from '../CustomEditor'
import { ContentItems } from '../Newsletter'
import './poll.scss'

interface PollProps {
  question: string
  link: string
  handleChange: (value: string, type: EditorType) => void
  onSave: () => Promise<void>
  onCancel: () => void
  onDelete: (target: ContentItems) => void
}

const Poll: React.FC<PollProps> = ({
  question,
  link,
  handleChange,
  onSave,
  onCancel,
  onDelete,
}) => {
  const handleChangeLink = (e: ChangeEvent<HTMLInputElement>) => {
    handleChange(e.target.value, 'link')
  }

  return (
    <div className="poll">
      <h2>Ajouter un sondage (Optionnel)</h2>
      <p className="title">Lien</p>
      <input
        type="text"
        className="input-dark"
        value={link}
        onChange={handleChangeLink}
      />
      <div>
        <p className="title">Question</p>
        <div>
          <CustomEditor
            baseState={convertStringToEditorState(question)}
            handleChange={handleChange}
            type="question"
          />
        </div>

        <div className="buttons">
          <button className="btnCancel" onClick={onCancel}>
            Annuler
          </button>
          <button className="btnValid" onClick={onSave}>
            Sauvegarder
          </button>
          <button className="btnDelete" onClick={() => onDelete('poll')}>
            Supprimer
          </button>
        </div>
      </div>
    </div>
  )
}

export default Poll
