import React from 'react'
import editing from '../../assets/icons/editing.png'
import { IPrice } from '../../models/price.model'

interface PriceSectionProps {
  getDate: (date: string) => string
  setPriceToSave: React.Dispatch<React.SetStateAction<IPrice>>
  priceToSave: IPrice
  price: IPrice
  prices: IPrice[]
  index: number
  isNextPrice?: boolean
}

const PriceRow: React.FC<PriceSectionProps> = ({
  getDate,
  setPriceToSave,
  priceToSave,
  price,
  prices,
  index,
  isNextPrice,
}) => {
  const editableLimit = 3

  return (
    <>
      <li
        className={
          priceToSave.startDate === price.startDate
            ? 'flex-bloc price-selected'
            : 'flex-bloc'
        }
      >
        <div className="prix">
          {price.price === '' ? '----' : price.price} €
        </div>
        <p>
          à partir de :{' '}
          <span className="capital">{getDate(price.startDate)}</span>
        </p>
        {index < editableLimit - 1 && (
          <img
            src={editing}
            onClick={() => setPriceToSave(isNextPrice ? price : prices[index])}
            alt="edit-icon"
          />
        )}
      </li>
      <hr />
    </>
  )
}

export default PriceRow
