import React from 'react'
import 'react-draft-wysiwyg/dist/react-draft-wysiwyg.css'
import { FluidType } from '../../enum/fluidTypes'
import { FrequencyInMonth } from '../../enum/frequency.enum'
import PriceSection from './PriceSection'
import './prices.scss'

const Prices: React.FC = () => {
  return (
    <>
      <div className="header">
        <h1 className="title pageTitle">Prix des fluides</h1>
      </div>
      <div className="prices">
        <PriceSection
          fluid={FluidType.ELECTRICITY}
          frequency={FrequencyInMonth.ELECTRICITY}
        />
        <PriceSection
          fluid={FluidType.WATER}
          frequency={FrequencyInMonth.WATER}
        />
        <PriceSection fluid={FluidType.GAS} frequency={FrequencyInMonth.GAS} />
      </div>
    </>
  )
}

export default Prices
