import React, { useContext } from 'react'
import { Navigate, Route, Routes } from 'react-router-dom'
import { UserContext } from '../../hooks/userContext'
import Consents from '../Consents/Consents'
import Login from '../Login/Login'
import Newsletter from '../Newsletter/Newsletter'
import Popups from '../Popups/Popups'
import Prices from '../Prices/Prices'

export const links: Record<
  string,
  { label: string; path: string; adminOnly?: boolean }
> = {
  newsletter: {
    label: 'Newsletter',
    path: '/newsletter',
  },
  popups: {
    label: 'Pop-ups',
    path: '/popups',
  },
  prices: {
    label: 'Prix',
    path: '/prices',
  },
  consents: {
    label: 'Consentements',
    path: '/consents',
    adminOnly: true,
  },
}

export const routes = Object.keys(links).map(key => ({
  label: links[key].label,
  path: links[key].path,
  adminOnly: links[key].adminOnly,
}))

const Router: React.FC = () => {
  const { user } = useContext(UserContext)

  return (
    <Routes>
      {user ? (
        <>
          <Route path={links.newsletter.path} element={<Newsletter />} />
          <Route path={links.prices.path} element={<Prices />} />
          <Route path={links.popups.path} element={<Popups />} />
          {user.isAdmin && (
            <Route path={links.consents.path} element={<Consents />} />
          )}
          <Route
            path="*"
            element={<Navigate replace to={links.newsletter.path} />}
          />
        </>
      ) : (
        <>
          <Route path="/login" element={<Login />} />
          <Route path="*" element={<Navigate replace to="/login" />} />
        </>
      )}
    </Routes>
  )
}

export default Router
