import React, { useContext } from 'react'
import { NavLink } from 'react-router-dom'
import logo from '../../assets/icons/ecolyo-logo.svg'
import { useAuth } from '../../hooks/useAuth'
import { UserContext } from '../../hooks/userContext'
import { routes } from '../Routes/Router'
import './sidebar.scss'

const SideBar: React.FC = () => {
  const { user } = useContext(UserContext)
  const { logoutUser } = useAuth()

  return (
    <nav className="menu">
      <div className="logo-container">
        <img src={logo} alt="Ecolyo logo" className="logo" />
      </div>
      <div className="menu-list">
        {user &&
          routes.map(
            route =>
              (!route.adminOnly || user.isAdmin) && (
                <NavLink
                  key={route.label}
                  to={route.path}
                  className={({ isActive }) => (isActive ? 'active' : '')}
                >
                  {route.label}
                </NavLink>
              )
          )}
        {process.env.NODE_ENV === 'development' && (
          <a href="/doc/" target="_blank">
            Swagger doc
          </a>
        )}
      </div>
      <div className="bottom">
        {user ? (
          <button className="btnValid" onClick={logoutUser}>
            Logout
          </button>
        ) : (
          <NavLink to="/login" className="active">
            Login
          </NavLink>
        )}
      </div>
    </nav>
  )
}

export default SideBar
