import { DateTime } from 'luxon'
export interface IConsent
  extends Omit<ConsentEntity, 'CreatedAt' | 'endDate' | 'inseeCode'> {
  startDate: DateTime
  endDate: DateTime
}

export interface ConsentEntity {
  ID: number
  CreatedAt: string
  endDate: string
  firstname: string
  lastname: string
  pointID: number
  address: string
  postalCode: string
  inseeCode: string
  city: string
  safetyOnBoarding: boolean
}

export interface IConsentPagination
  extends Omit<ConsentPaginationEntity, 'rows'> {
  rows: IConsent[]
}

export interface ConsentPaginationEntity {
  totalRows: number
  totalPages: number
  rows: ConsentEntity[]
}
