import axios, { AxiosRequestConfig } from 'axios'
import { toast } from 'react-toastify'
import { ICustomPopup } from '../models/customPopup.model'

export class CustomPopupService {
  /**
   * Save the customPopup info
   * @param customPopup
   * @param axiosHeaders
   */
  public saveCustomPopup = async (
    customPopup: ICustomPopup,
    axiosHeaders: AxiosRequestConfig
  ): Promise<void> => {
    try {
      await axios.put(
        `/api/animator/customPopup`,
        {
          ...customPopup,
        },
        axiosHeaders
      )
      toast.success('Pop-up personnalisée enregistrée !')
    } catch (e) {
      toast.error('Erreur lors de l’enregistrement de la pop-up personnalisée')
      console.error(e)
    }
  }

  /**
   * Gets the custom pop-up information
   */
  public getCustomPopupInfo = async (): Promise<ICustomPopup | null> => {
    try {
      const { data } = await axios.get(`/api/common/customPopup`)
      return data as ICustomPopup
    } catch (e) {
      console.error('error', e)
      return null
    }
  }
}
