import axios, { AxiosRequestConfig } from 'axios'
import { toast } from 'react-toastify'
import { IPrice } from '../models/price.model'
export class PricesService {
  /**
   * Save the partnersInfo
   * @param price
   * @param axiosHeaders
   */
  public savePrice = async (
    price: IPrice,
    axiosHeaders: AxiosRequestConfig
  ): Promise<void> => {
    try {
      await axios.put(`/api/animator/prices`, price, axiosHeaders)
      toast.success('Prix des fluides mis à jour !')
    } catch (e) {
      toast.error('Erreur lors de la mise à jour des prix des fluides')
      console.error(e)
    }
  }

  /**
   * Gets the prices by fluid
   */
  public getPricesByFluid = async (fluidType: number): Promise<IPrice[]> => {
    try {
      const { data } = await axios.get(`/api/common/prices/${fluidType}`)
      return data
    } catch (e) {
      console.error('error', e)
      return []
    }
  }
}
