import React, { useContext } from 'react'
import routes from '../../constants/routes.json'
import logo from '../../assets/icons/ecolyo-logo.svg'
import './menu.scss'
import { NavLink } from 'react-router-dom'
import { UserContext } from '../../hooks/userContext'
import { useAuth } from '../../hooks/useAuth'
import { Route } from '../../models/route.model'

const Menu: React.FC = () => {
  const { user } = useContext(UserContext)
  const { logoutUser } = useAuth()
  return (
    <nav className={'menu'}>
      <div className="logo-container">
        <img src={logo} alt="Ecolyo logo" className="logo" />
      </div>
      <div className="menu-list">
        {routes.map((route: Route, index: number) => {
          return (
            <NavLink key={index} to={route.path} activeClassName="active">
              {route.label}
            </NavLink>
          )
        })}
      </div>
      <div className="administration">
        {user ? (
          <button className="btnValid" onClick={logoutUser}>
            Logout
          </button>
        ) : (
          <NavLink to="/login" activeClassName="active">
            Login
          </NavLink>
        )}
      </div>
    </nav>
  )
}

export default Menu
