import React, { useContext } from 'react'
import { NavLink } from 'react-router-dom'
import routes from '../../constants/routes.json'
import { useAuth } from '../../hooks/useAuth'
import { UserContext } from '../../hooks/userContext'
import { Route } from '../../models/route.model'
import './navbar.scss'

const Navbar: React.FC = () => {
  const { user } = useContext(UserContext)
  const { logoutUser } = useAuth()
  return (
    <div className="navbar">
      <div className="menu-list">
        {routes.map((route: Route, index: number) => (
          <NavLink key={index} to={route.path} activeClassName="active">
            {route.label}
          </NavLink>
        ))}
      </div>
      {user && (
        <button className="btnValid logButton" onClick={logoutUser}>
          Logout
        </button>
      )}
    </div>
  )
}

export default Navbar
