import React, { useContext } from 'react'
import { Redirect, Route, Switch } from 'react-router-dom'
import { UserContext } from '../../hooks/userContext'
import Consents from '../Consents/Consents'
import Editing from '../Editing/Editing'
import Login from '../Login/Login'
import Prices from '../Prices/Prices'
import Settings from '../Settings/Settings'
import PrivateRoute from './PrivateRoute'

const Routes: React.FC = () => {
  const { user } = useContext(UserContext)

  return (
    <Switch>
      {user && <Redirect path="/login" to="/editing" />}
      <Route path="/login" component={Login} />
      <PrivateRoute exact path="/editing" component={Editing} />
      <PrivateRoute exact path="/prices" component={Prices} />
      <PrivateRoute exact path="/settings" component={Settings} />
      <PrivateRoute exact path="/consents" component={Consents} />
      <Redirect path="*" to="/editing" />
    </Switch>
  )
}

export default Routes
