import axios, { AxiosRequestConfig } from 'axios'
import { IPartnersInfo } from '../models/partnersInfo.model'
import { toast } from 'react-toastify'
export class PartnersInfoService {
  /**
   * Save the partnersInfo
   * @param partnersInfo
   * @param axiosHeaders
   */
  public savePartnersInfo = async (
    partnersInfo: IPartnersInfo,
    axiosHeaders: AxiosRequestConfig
  ): Promise<void> => {
    try {
      await axios.put(
        `/api/admin/partnersInfo`,
        {
          grdf_failure: partnersInfo.grdf_failure,
          enedis_failure: partnersInfo.enedis_failure,
          egl_failure: partnersInfo.egl_failure,
          notification_activated: partnersInfo.notification_activated,
        },
        axiosHeaders
      )
      toast.success('Information des partenaires mises à jour !')
    } catch (e) {
      toast.error('Failed to save partners info')
      console.error(e)
    }
  }

  /**
   * Gets the partners information
   */
  public getPartnersInfo = async (): Promise<IPartnersInfo | null> => {
    try {
      const { data } = await axios.get(`/api/common/partnersInfo`)
      return data as IPartnersInfo
    } catch (e) {
      console.error('error', e)
      return null
    }
  }
}
