/* eslint-disable react/no-unescaped-entities */
import React from 'react'
import styles from './consents.module.scss'
import Modal from '../Modal/Modal'
import dowloadIcon from '../../assets/icons/ico-download.svg'

interface DowloadModalProps {
  toggleOpenModal: () => void
  exportData: () => void
}
const DowloadModal: React.FC<DowloadModalProps> = ({
  toggleOpenModal,
  exportData,
}: DowloadModalProps) => {
  return (
    <Modal>
      <div className={styles.modalContent}>
        <img
          src={dowloadIcon}
          className={styles.modalIcon}
          alt="dowload-icon"
        />
        <div className={styles.modalTitle}>
          Voulez-vous télécharger les consentements sélectionnés ?
        </div>
        <div className={styles.text1}>
          Un fichier Excel contenant les consentements sera téléchargé.
        </div>
        <div className={styles.text2}>
          Attention ce fichier contient des données personnelles. Veillez à ne
          l'utiliser qu'en cas de contrôle de la part d'Enedis et à supprimer ce
          fichier ensuite de tout ordinateur.
        </div>
        <div className="buttons">
          <button className="btnCancel2" onClick={toggleOpenModal}>
            Annuler
          </button>
          <button className="btnValid" onClick={exportData}>
            Télécharger
          </button>
        </div>
      </div>
    </Modal>
  )
}
export default DowloadModal
