import React from 'react'
import { EditorState, Modifier, ContentState } from 'draft-js'
import htmlToDraft from 'html-to-draftjs'
import { useState } from 'react'

interface EcolyoLinkProps {
  onChange?: (editorState: EditorState) => void
  editorState: EditorState
}
interface LinkState {
  displayTitle: string
  link: string
}

const CustomLink: React.FC<EcolyoLinkProps> = ({
  onChange,
  editorState,
}: EcolyoLinkProps) => {
  const [open, setOpen] = useState<boolean>(false)
  const links: LinkState[] = [
    {
      displayTitle: 'Consommation',
      link: 'consumption',
    },
    {
      displayTitle: 'Écogestes',
      link: 'ecogestures',
    },
    {
      displayTitle: 'Analyse',
      link: 'analysis',
    },
    {
      displayTitle: 'Options',
      link: 'options',
    },
  ]
  const appendLink = (link: LinkState) => {
    const data = `<a href="{cozyUrl}${
      link.link
    }">${link.displayTitle.toLowerCase()}</a>`
    const { contentBlocks, entityMap } = htmlToDraft(data)

    const contentState = Modifier.replaceWithFragment(
      editorState.getCurrentContent(),
      editorState.getSelection(),
      ContentState.createFromBlockArray(contentBlocks, entityMap).getBlockMap()
    )
    const result = EditorState.push(
      editorState,
      contentState,
      'insert-fragment'
    )
    if (onChange) {
      onChange(result)
    }
  }
  return (
    <div
      onClick={() => setOpen(!open)}
      className="rdw-block-wrapper"
      aria-label="rdw-block-control"
      role="button"
      tabIndex={0}
      aria-expanded={false}
    >
      <div
        className="rdw-dropdown-wrapper rdw-block-dropdown"
        aria-label="rdw-dropdown"
        style={{ width: 200 }}
      >
        <div className="rdw-dropdown-selectedtext">
          <span>Lien Ecolyo</span>
          <div className={`rdw-dropdown-caretto${open ? 'close' : 'open'}`} />
        </div>
        {open && (
          <ul
            className={
              open
                ? 'rdw-dropdown-optionwrapper'
                : 'rdw-dropdown-optionwrapper placeholder-ul'
            }
          >
            {links.map((item: LinkState) => {
              return (
                <li
                  className="rdw-dropdownoption-default placeholder-li"
                  onClick={() => appendLink(item)}
                  key={item.link}
                >
                  {item.displayTitle}
                </li>
              )
            })}
          </ul>
        )}
      </div>
    </div>
  )
}

export default CustomLink
