import React, { useContext } from 'react'
import { NavLink } from 'react-router-dom'
import editing from '../../assets/icons/editing.svg'
import settings from '../../assets/icons/settings.svg'
import './navbar.scss'
import { UserContext } from '../../hooks/userContext'
import { useAuth } from '../../hooks/useAuth'

const Navbar: React.FC = () => {
  const { user } = useContext(UserContext)
  const { logoutUser } = useAuth()
  return (
    <div className="navbar">
      <div className="menu-list">
        <NavLink to={'/editing'} activeClassName="active">
          <img src={editing} className="navbar-icon" alt="Editing icon" />
          Edition
        </NavLink>
        <NavLink to={'/settings'} activeClassName="active">
          <img src={settings} className="navbar-icon" alt="Settings icon" />
          Paramètres
        </NavLink>
      </div>
      {user && (
        <button className="btnValid logButton" onClick={logoutUser}>
          Logout
        </button>
      )}
    </div>
  )
}

export default Navbar
